/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1122.BuilderCreativeTab;
import mcinterface1122.BuilderTileEntity;
import mcinterface1122.IBuilderItemInterface;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class BuilderItem
extends Item
implements IBuilderItemInterface {
    protected static final Map<AItemBase, BuilderItem> itemMap = new LinkedHashMap<AItemBase, BuilderItem>();
    private final AItemBase item;

    public BuilderItem(AItemBase item) {
        this.item = item;
        this.func_77664_n();
        this.func_77625_d(item.getStackSize());
        itemMap.put(item, this);
    }

    @Override
    public AItemBase getItem() {
        return this.item;
    }

    public String func_77653_i(ItemStack stack) {
        return this.item.getItemName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltipLines, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            this.item.addTooltipLines(tooltipLines, new WrapperNBT(stack.func_77978_p()));
        } else {
            this.item.addTooltipLines(tooltipLines, InterfaceManager.coreInterface.getNewNBTWrapper());
        }
    }

    public int func_77626_a(ItemStack stack) {
        return this.item instanceof IItemFood ? ((IItemFood)((Object)this.item)).getTimeToEat() : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        IItemFood food;
        if (this.item instanceof IItemFood && (food = (IItemFood)((Object)this.item)).getTimeToEat() > 0) {
            return food.isDrink() ? EnumAction.DRINK : EnumAction.EAT;
        }
        return EnumAction.NONE;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (this.item instanceof ItemItem && ((JSONItem)((ItemItem)this.item).definition).weapon != null && slot.equals((Object)EntityEquipmentSlot.MAINHAND)) {
            ItemItem weapon = (ItemItem)this.item;
            if (((JSONItem)weapon.definition).weapon.attackDamage != 0.0) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", ((JSONItem)weapon.definition).weapon.attackDamage - 1.0, 0));
            }
            if (((JSONItem)weapon.definition).weapon.attackCooldown != 0.0) {
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 20.0 / ((JSONItem)weapon.definition).weapon.attackCooldown - 4.0, 0));
            }
        }
        return multimap;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            if (this.item.onBlockClicked(WrapperWorld.getWrapperFor(world), WrapperPlayer.getWrapperFor(player), new Point3D(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), ABlockBase.Axis.valueOf(facing.name()))) {
                return EnumActionResult.SUCCESS;
            }
            if (player != null && player.func_70093_af()) {
                TileEntity tile;
                if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
                    return ((AEntityB_Existing)((BuilderTileEntity)tile).tileEntity).interact(WrapperPlayer.getWrapperFor(player)) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
                return EnumActionResult.FAIL;
            }
            return this.item instanceof IItemFood && ((IItemFood)((Object)this.item)).getTimeToEat() > 0 ? EnumActionResult.PASS : EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            if (this.item instanceof IItemFood && ((IItemFood)((Object)this.item)).getTimeToEat() > 0 && player.func_71043_e(true) || this.item instanceof ItemPartGun && ((JSONPart)((ItemPartGun)this.item).definition).gun.handHeld) {
                player.func_184598_c(hand);
            }
            return this.item.onUsed(WrapperWorld.getWrapperFor(world), WrapperPlayer.getWrapperFor(player)) ? new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand)) : new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (this.item instanceof IItemFood) {
            if (entityLiving instanceof EntityPlayer) {
                IItemFood food = (IItemFood)((Object)this.item);
                EntityPlayer player = (EntityPlayer)entityLiving;
                player.func_71024_bL().func_75122_a(food.getHungerAmount(), food.getSaturationAmount());
                List<JSONPotionEffect> effects = food.getEffects();
                if (!world.field_72995_K && effects != null) {
                    for (JSONPotionEffect effect : effects) {
                        Potion potion = Potion.func_180142_b((String)effect.name);
                        if (potion != null) {
                            player.func_70690_d(new PotionEffect(potion, effect.duration, effect.amplifier, false, false));
                            continue;
                        }
                        throw new NullPointerException("Potion " + effect.name + " does not exist.");
                    }
                }
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
                }
            }
            stack.func_190918_g(1);
        }
        return stack;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return this.item.canBreakBlocks();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Map.Entry<AItemBase, BuilderItem> entry : itemMap.entrySet()) {
            boolean hideOnCreativeTab;
            AItemPack item = (AItemPack)entry.getKey();
            BuilderItem mcItem = entry.getValue();
            boolean bl = hideOnCreativeTab = ((AJSONItem)item.definition).general.hideOnCreativeTab || item instanceof AItemSubTyped && ((AItemSubTyped)item).subDefinition.hideOnCreativeTab;
            if (!(hideOnCreativeTab || ((AJSONItem)item.definition).packID.equals(InterfaceManager.coreModID) && ((AJSONItem)item.definition).systemName.contains("invisible"))) {
                String tabID = item.getCreativeTabID();
                if (!BuilderCreativeTab.createdTabs.containsKey(tabID)) {
                    JSONPack packConfiguration = PackParser.getPackConfiguration(tabID);
                    BuilderCreativeTab.createdTabs.put(tabID, new BuilderCreativeTab(packConfiguration.packName, itemMap.get(PackParser.getItem(packConfiguration.packID, packConfiguration.packItem))));
                }
                BuilderCreativeTab.createdTabs.get(tabID).addItem(item, mcItem);
            }
            event.getRegistry().register((IForgeRegistryEntry)((Item)mcItem.setRegistryName(item.getRegistrationName())).func_77655_b(item.getRegistrationName()));
            if (((AJSONItem)item.definition).general.oreDict == null) continue;
            OreDictionary.registerOre((String)((AJSONItem)item.definition).general.oreDict, (Item)mcItem);
        }
    }
}

